/*
 * Decompiled with CFR 0.152.
 */
package sheepDog;

import java.applet.Applet;
import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.JOptionPane;
import org.colos.ejs.external.ExternalApp;
import org.colos.ejs.external.ExternalAppsHandler;
import org.colos.ejs.external.ExternalClient;
import org.opensourcephysics.ejs.Model;
import org.opensourcephysics.ejs.Simulation;
import org.opensourcephysics.ejs.View;
import org.opensourcephysics.ejs.control.MethodWithOneParameter;
import org.opensourcephysics.numerics.EulerRichardson;
import org.opensourcephysics.numerics.ODE;
import sheepDog.SheepDogSimulation;
import sheepDog.SheepDogView;

public class SheepDog
implements Model,
ExternalClient {
    public SheepDogSimulation _simulation = null;
    public SheepDogView _view = null;
    public SheepDog _model = this;
    public Applet __theApplet = null;
    public MethodWithOneParameter __initMethod = null;
    private ExternalAppsHandler _external = new ExternalAppsHandler("sheepDog.jar", (ExternalClient)this);
    public double time = 0.0;
    public double dt = 0.05;
    public double G = 9.81;
    public double PI = 3.141592654;
    public int fps = 25;
    public double mass = 10.0;
    public double x = 0.0;
    public double y = 100.0;
    public double vx = 10.0;
    public double vy = 0.0;
    public double ax = 0.0;
    public double ay = 0.0;
    public double fx = 0.0;
    public double fy = 0.0;
    public double f = -10.0;
    public double force = 10.0;
    public double dogx = 0.0;
    public double dogy = 0.0;
    public boolean attractive = true;
    public double distance = 0.0;
    public double dx = 0.0;
    public double dy = 0.0;
    public double fmag = 0.0;
    public double amag = 0.0;
    public double vmag = 0.0;
    public String label = "Play";
    public double ymin = -200.0;
    public double ymax = 200.0;
    public double xmin = -200.0;
    public double xmax = 200.0;
    public boolean showPlot = false;
    public boolean showF = false;
    public boolean showA = false;
    public boolean showV = false;
    public boolean showFmag = true;
    public boolean showAmag = true;
    public boolean showVmag = true;
    public boolean horizontalOnly = false;
    public double amagScale = 50.0;
    public double vmagScale = 10.0;
    public double fmagScale = 5.0;
    public String gifString = "_examples/_data/cabbage.gif";
    private _ODE_evolution1 _ODEi_evolution1;

    public static void main(String[] stringArray) {
        SheepDog sheepDog = new SheepDog();
        if (stringArray.length > 0 && stringArray[0].equals("-init")) {
            try {
                sheepDog.__initMethod = new MethodWithOneParameter(0, (Object)sheepDog, stringArray[1], null, null, (Object)sheepDog);
                sheepDog.__initMethod.invoke(0, (Object)sheepDog);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public SheepDog() {
        this(null, null, null, null);
    }

    public SheepDog(String string, Frame frame, URL uRL, Applet applet) {
        this.__theApplet = applet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new SheepDogSimulation(this, string, frame, uRL);
        this._view = (SheepDogView)this._simulation.getView();
    }

    public View getView() {
        return this._view;
    }

    public Simulation getSimulation() {
        return this._simulation;
    }

    public void _play() {
        this._simulation.play();
    }

    public void _pause() {
        this._simulation.pause();
    }

    public void _step() {
        this._simulation.step();
    }

    public void _setFPS(int n) {
        this._simulation.setFPS(n);
    }

    public void _setDelay(int n) {
        this._simulation.setDelay(n);
    }

    public void _reset() {
        this._external.reset();
        this._simulation.reset();
        if (this.__initMethod != null) {
            this.__initMethod.invoke(0, (Object)this);
        }
    }

    public void _initialize() {
        this._external.reset();
        this._simulation.initialize();
    }

    public void _alert(String string, String string2, String string3) {
        if (this._view != null) {
            JOptionPane.showMessageDialog(this._view.getVisual(string), string3, string2, 1);
        } else {
            JOptionPane.showMessageDialog(null, string3, string2, 1);
        }
    }

    public void _print(String string) {
        if (this._view != null) {
            this._view.print(string);
        } else {
            System.out.print(string);
        }
    }

    public void _println(String string) {
        if (this._view != null) {
            this._view.println(string);
        } else {
            System.out.print(string);
        }
    }

    public void _println() {
        if (this._view != null) {
            this._view.println();
        } else {
            System.out.println();
        }
    }

    public void _clearMessages() {
        if (this._view != null) {
            this._view.clearMessages();
        }
    }

    public String _format(double d, String string) {
        DecimalFormat decimalFormat = new DecimalFormat(string);
        return decimalFormat.format(d);
    }

    public String _getParameter(String string) {
        if (this.__theApplet == null) {
            return null;
        }
        return this.__theApplet.getParameter(string);
    }

    public boolean _isPlaying() {
        return this._simulation.isPlaying();
    }

    public boolean _isPaused() {
        return this._simulation.isPaused();
    }

    public boolean _saveState(String string) {
        return this._simulation.saveState(string);
    }

    public boolean _readState(String string) {
        return this._simulation.readState(string);
    }

    public boolean _setVariables(String string, String string2, String string3) {
        return this._simulation.setVariables(string, string2, string3);
    }

    public boolean _setVariables(String string) {
        return this._simulation.setVariables(string);
    }

    public String _getVariables(String string) {
        return this._simulation.getVariable(string);
    }

    public void _clearView() {
        if (this._view != null) {
            this._view.initialize();
        }
    }

    public void _resetView() {
        if (this._view != null) {
            this._view.reset();
            this._view.initialize();
        }
    }

    public void _onExit() {
        this._external.quit();
        this._view.onExit();
    }

    public String _externalInitCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    public synchronized void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    public synchronized void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _initialization1() {
        if (this.attractive) {
            this.gifString = "_examples/_data/cabbage.gif";
            this.f = -this.force;
        } else {
            this.gifString = "_examples/_data/doggy.gif";
            this.f = this.force;
        }
        this.dx = this.x - this.dogx;
        this.dy = this.y - this.dogy;
        this.distance = Math.sqrt(this.dx * this.dx + this.dy * this.dy);
        this.fx = this.dx / this.distance * this.f;
        this.fy = this.dy / this.distance * this.f;
        this.fy = this.horizontalOnly ? 0.0 : this.fy;
        this.ax = this.fx / this.mass;
        this.ay = this.fy / this.mass;
        this.fmag = Math.sqrt(this.fx * this.fx + this.fy * this.fy);
        this.amag = Math.sqrt(this.ax * this.ax + this.ay * this.ay);
        this.vmag = Math.sqrt(this.vx * this.vx + this.vy * this.vy);
        this.label = "Play";
        this.time = 0.0;
    }

    public void _evolution2() {
        if (this.attractive) {
            this.gifString = "_examples/_data/cabbage.gif";
            this.f = -this.force;
        } else {
            this.gifString = "_examples/_data/doggy.gif";
            this.f = this.force;
        }
        this.dx = this.x - this.dogx;
        this.dy = this.y - this.dogy;
        this.distance = Math.sqrt(this.dx * this.dx + this.dy * this.dy);
        this.fx = this.dx / this.distance * this.f;
        this.fy = this.dy / this.distance * this.f;
        this.fy = this.horizontalOnly ? 0.0 : this.fy;
        this.ax = this.fx / this.mass;
        this.ay = this.fy / this.mass;
    }

    public void _constraints1() {
        this.fmag = Math.sqrt(this.fx * this.fx + this.fy * this.fy);
        this.amag = Math.sqrt(this.ax * this.ax + this.ay * this.ay);
        this.vmag = Math.sqrt(this.vx * this.vx + this.vy * this.vy);
    }

    public void playpause() {
        if (this.label == "Play") {
            this.label = "Pause";
            this._play();
        } else {
            this.label = "Play";
            this._pause();
        }
    }

    public double distance() {
        double d = this.dogx - this.x;
        double d2 = this.dogy - this.y;
        return Math.sqrt(d * d + d2 * d2);
    }

    public void fpsSet() {
        this._setFPS(this.fps);
    }

    public void clearTrace() {
        this._view.getElement("Trace").reset();
    }

    public double _method_for_ay_sizey() {
        return -this.ay;
    }

    public void _method_for_buttonPlayPause_action() {
        this.playpause();
    }

    public boolean _method_for_buttonStep_enabled() {
        return this.label == "Play";
    }

    public void _method_for_buttonStep_action() {
        this._step();
    }

    public void _method_for_buttonReset_action() {
        this._reset();
    }

    public void _method_for_buttonInit_action() {
        this._initialize();
    }

    public void _method_for_ClearTrace_action() {
        this.clearTrace();
    }

    public void _method_for_fps_action() {
        this.fpsSet();
    }

    public void reset() {
        this.time = 0.0;
        this.dt = 0.05;
        this.G = 9.81;
        this.PI = 3.141592654;
        this.fps = 25;
        this.mass = 10.0;
        this.x = 0.0;
        this.y = 100.0;
        this.vx = 10.0;
        this.vy = 0.0;
        this.ax = 0.0;
        this.ay = 0.0;
        this.fx = 0.0;
        this.fy = 0.0;
        this.f = -10.0;
        this.force = 10.0;
        this.dogx = 0.0;
        this.dogy = 0.0;
        this.attractive = true;
        this.distance = 0.0;
        this.dx = 0.0;
        this.dy = 0.0;
        this.fmag = 0.0;
        this.amag = 0.0;
        this.vmag = 0.0;
        this.label = "Play";
        this.ymin = -200.0;
        this.ymax = 200.0;
        this.xmin = -200.0;
        this.xmax = 200.0;
        this.showPlot = false;
        this.showF = false;
        this.showA = false;
        this.showV = false;
        this.showFmag = true;
        this.showAmag = true;
        this.showVmag = true;
        this.horizontalOnly = false;
        this.amagScale = 50.0;
        this.vmagScale = 10.0;
        this.fmagScale = 5.0;
        this.gifString = "_examples/_data/cabbage.gif";
        this._ODEi_evolution1 = new _ODE_evolution1();
    }

    public void initialize() {
        this._initialization1();
    }

    public synchronized void step() {
        this._ODEi_evolution1.step();
        this._evolution2();
    }

    public void update() {
        this._constraints1();
    }

    private class _ODE_evolution1
    implements ODE {
        private EulerRichardson __solver = null;
        private double[] __state = null;
        private double _vx;
        private double _vy;
        private double _x;
        private double _y;
        private double _time;

        _ODE_evolution1() {
            this.initArrays();
            this.__solver = new EulerRichardson((ODE)this);
            this.__solver.initialize(SheepDog.this.dt);
        }

        private void initArrays() {
            this.__state = new double[5];
        }

        void step() {
            this.__solver.setStepSize(SheepDog.this.dt);
            this.__solver.step();
            int n = 0;
            SheepDog.this.vx = this.__state[n++];
            SheepDog.this.vy = this.__state[n++];
            SheepDog.this.x = this.__state[n++];
            SheepDog.this.y = this.__state[n++];
            SheepDog.this.time = this.__state[n++];
        }

        public double[] getState() {
            int n = 0;
            this.__state[n++] = SheepDog.this.vx;
            this.__state[n++] = SheepDog.this.vy;
            this.__state[n++] = SheepDog.this.x;
            this.__state[n++] = SheepDog.this.y;
            this.__state[n++] = SheepDog.this.time;
            return this.__state;
        }

        public void getRate(double[] dArray, double[] dArray2) {
            int n = 0;
            this._vx = dArray[n++];
            this._vy = dArray[n++];
            this._x = dArray[n++];
            this._y = dArray[n++];
            this._time = dArray[n++];
            n = 0;
            dArray2[n++] = this._ODE_evolution1_1(this._vx, this._vy, this._x, this._y, this._time);
            dArray2[n++] = this._ODE_evolution1_2(this._vx, this._vy, this._x, this._y, this._time);
            dArray2[n++] = this._ODE_evolution1_3(this._vx, this._vy, this._x, this._y, this._time);
            dArray2[n++] = this._ODE_evolution1_4(this._vx, this._vy, this._x, this._y, this._time);
            dArray2[n++] = 1.0;
        }

        private double _ODE_evolution1_1(double d, double d2, double d3, double d4, double d5) {
            return SheepDog.this.ax;
        }

        private double _ODE_evolution1_2(double d, double d2, double d3, double d4, double d5) {
            return SheepDog.this.ay;
        }

        private double _ODE_evolution1_3(double d, double d2, double d3, double d4, double d5) {
            return d;
        }

        private double _ODE_evolution1_4(double d, double d2, double d3, double d4, double d5) {
            return d2;
        }
    }
}

