/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.flashlauncher;

import edu.colorado.phet.flashlauncher.FlashHTML;
import edu.colorado.phet.flashlauncher.util.BareBonesBrowserLaunch;
import edu.colorado.phet.flashlauncher.util.FileUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class FlashLauncher {
    private String simName;
    private String language;
    private String country;
    private String deployment = "standalone-jar";
    private String distributionTag = "null";
    private String installationTimestamp = "null";
    private String installerCreationTimestamp = "null";
    private static JTextArea jTextArea;

    public FlashLauncher() throws IOException {
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("flash-launcher-args.txt");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string = bufferedReader.readLine();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        FlashLauncher.println("FlashLauncher obtained line from flash-launcher-args.txt: " + string);
        this.simName = stringTokenizer.nextToken();
        this.language = stringTokenizer.nextToken();
        this.country = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "null";
        if (stringTokenizer.hasMoreTokens() && stringTokenizer.nextToken().equals("-dev")) {
            FlashLauncher.println("FlashLauncher.FlashLauncher dev");
            JFrame jFrame = new JFrame("Text");
            jTextArea = new JTextArea(10, 50);
            jFrame.setContentPane(new JScrollPane(jTextArea));
            jFrame.setVisible(true);
            jFrame.setDefaultCloseOperation(3);
            jFrame.setSize(800, 600);
        }
    }

    public static void println(String string) {
        System.out.println(string);
        if (jTextArea != null) {
            jTextArea.append(string + "\n");
        }
    }

    private void start(String[] stringArray) throws IOException {
        File file;
        Properties properties = FlashLauncher.readProperties(this.simName);
        String string = properties.getProperty("version.major");
        String string2 = properties.getProperty("version.minor");
        String string3 = properties.getProperty("version.dev");
        String string4 = properties.getProperty("version.revision");
        String string5 = properties.getProperty("version.timestamp");
        if (properties.getProperty("distribution.tag") != null) {
            this.distributionTag = properties.getProperty("distribution.tag");
        }
        if (this.simName.equals("flash-common-strings")) {
            String string6 = "";
            string6 = string6 + "PhET Flash common strings : version ";
            string6 = string6 + string + "." + string2 + "." + string3 + " (" + string4 + ")";
            string6 = string6 + "\n\n";
            string6 = string6 + "This JAR file contains common strings used by all PhET Flash simulations.\nYou can use this JAR file to translate common strings with Translation Utility.\nBut testing those translations is not currently supported.";
            JOptionPane.showMessageDialog(null, string6);
            return;
        }
        FlashLauncher.println("FlashLauncher.start");
        String string7 = System.getProperty("java.io.tmpdir") + System.getProperty("file.separator") + "phet-" + this.simName;
        FlashLauncher.println("unzipping to directory = " + string7);
        File file2 = new File(string7);
        File file3 = this.getJARFile();
        FlashLauncher.println("jarfile = " + file3);
        FlashLauncher.println("Starting unzip jarfile=" + file3 + ", unzipDir=" + file2);
        FileUtils.unzip(file3, file2);
        FlashLauncher.println("Finished unzip");
        String string8 = FlashLauncher.readBackgroundColor(properties);
        String string9 = "false";
        if (!string3.equals("0") && !string3.equals("00")) {
            string9 = "true";
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-dev")) continue;
            string9 = "true";
        }
        String string10 = FlashHTML.localeString(this.language, this.country);
        File file4 = new File(file2, this.simName + "-strings_" + string10 + ".xml");
        if (!file4.exists()) {
            file4 = new File(file2, this.simName + "-strings_en.xml");
            FlashLauncher.println("WARNING: could not find sim strings for " + string10 + ", using default en.");
        }
        if (!(file = new File(file2, "common-strings_" + string10 + ".xml")).exists()) {
            file = new File(file2, "common-strings_en.xml");
            FlashLauncher.println("WARNING: could not find common strings for " + string10 + ", using default en.");
        }
        String string11 = FlashHTML.rawFile(new File(file2, "credits.txt"));
        String string12 = FlashHTML.encodeXMLFile(file4);
        String string13 = FlashHTML.encodeXMLFile(file);
        Properties properties2 = FlashLauncher.readProperties("software-agreement");
        String string14 = properties2.getProperty("version");
        String string15 = FlashHTML.rawFile(new File(file2, "software-agreement.htm"));
        String string16 = FlashHTML.encodeXML(string15);
        String string17 = FlashHTML.extractTitleFromXML(file4);
        if (string17 == null && (string17 = FlashHTML.extractTitleFromXML(new File(file2, this.simName + "-strings_en.xml"))) == null) {
            string17 = this.simName;
        }
        String string18 = FlashHTML.generateHTML(this.simName, this.language, this.country, this.deployment, this.distributionTag, this.installationTimestamp, this.installerCreationTimestamp, string, string2, string3, string4, string5, string9, string8, string12, string13, "8", "flash-template.html", string14, string16, string11, string17);
        File file5 = new File(file2, this.simName + "_" + string10 + ".html");
        FileOutputStream fileOutputStream = new FileOutputStream(file5);
        fileOutputStream.write(string18.getBytes());
        fileOutputStream.close();
        FlashLauncher.println("Starting openurl");
        BareBonesBrowserLaunch.openURL("file://" + file5.getAbsolutePath());
    }

    private static Properties readProperties(String string) {
        String string2 = string + ".properties";
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(string2);
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return properties;
    }

    private static String readBackgroundColor(Properties properties) {
        String string = properties.getProperty("bgcolor");
        if (string == null) {
            string = "#ffffff";
        }
        return string;
    }

    private File getJARFile() {
        URL uRL = FlashLauncher.class.getProtectionDomain().getCodeSource().getLocation();
        try {
            return new File(URLDecoder.decode(uRL.getFile(), "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            try {
                return new File(URLDecoder.decode(uRL.getPath(), "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException2) {
                unsupportedEncodingException2.printStackTrace();
                return new File(uRL.getPath());
            }
        }
    }

    public static void main(String[] stringArray) throws IOException {
        System.out.println("FlashLauncher.main started");
        new FlashLauncher().start(stringArray);
        System.out.println("FlashLauncher.main finished");
    }
}

