/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.ehockey;

import edu.colorado.phet.common.phetcommon.view.util.SimStrings;
import edu.colorado.phet.ehockey.BarrierList;
import edu.colorado.phet.ehockey.Charge;
import edu.colorado.phet.ehockey.ElectricHockeyApplication;
import edu.colorado.phet.ehockey.Force;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PlayingField
extends JPanel {
    private ElectricHockeyApplication electricHockeyApplication;
    private int fieldWidth;
    private int fieldHeight;
    private Rectangle plusBag;
    private Rectangle minusBag;
    private Rectangle chargeBag;
    Rectangle goal;
    private int bagWidth;
    private Color fieldColor;
    private JLabel bagLabel;
    private Font fieldFont;
    private Color barrierColor;
    private Graphics2D g2D;
    private Charge grabbedCharge;
    private Force grabbedChargeForce;
    private boolean newChargeIsGrabbed;
    private boolean oldChargeIsGrabbed;
    private int grabbedChargeIndex;
    private int barrierState;
    private BufferedImage fieldLinesImage;
    private Stroke pathStroke = new BasicStroke(1.0f, 2, 0, 1.0f, new float[]{10.0f, 5.0f}, 0.0f);
    private Color pathColor = Color.red;

    public PlayingField(int n, int n2, ElectricHockeyApplication electricHockeyApplication) {
        this.electricHockeyApplication = electricHockeyApplication;
        this.fieldWidth = n;
        this.fieldHeight = n2;
        this.setSize(n, n2);
        this.fieldLinesImage = new BufferedImage(n, n2, 1);
        this.fieldColor = new Color(230, 235, 255);
        this.setBackground(this.fieldColor);
        this.barrierColor = new Color(100, 100, 250);
        this.fieldFont = new Font("serif", 0, 50);
        this.bagWidth = n / 15;
        this.plusBag = new Rectangle(8 * n / 10, 10, this.bagWidth, this.bagWidth);
        this.minusBag = new Rectangle(8 * n / 10 + this.bagWidth, 10, this.bagWidth, this.bagWidth);
        this.chargeBag = this.plusBag.union(this.minusBag);
        this.bagLabel = new JLabel("edu.colorado.phet.ehockey.Charge Bags");
        this.bagLabel.setBackground(Color.white);
        this.newChargeIsGrabbed = false;
        this.oldChargeIsGrabbed = false;
        this.barrierState = electricHockeyApplication.getControlPanel().getLevelState();
        this.goal = new Rectangle(89 * n / 100, n2 / 2 - 25, 10, 50);
        this.addMouseListener(new FieldMouseListener());
        this.addMouseMotionListener(new FieldMouseMotionListener());
        this.repaint();
    }

    public void updateBufferedImage() {
        Graphics2D graphics2D = (Graphics2D)this.fieldLinesImage.getGraphics();
        this.electricHockeyApplication.getFieldGrid().paint(graphics2D);
    }

    public void paintAgain() {
        this.repaint();
    }

    public void paintComponent(Graphics graphics) {
        int n;
        super.paintComponent(graphics);
        this.g2D = (Graphics2D)graphics;
        if (this.electricHockeyApplication.isAntialias()) {
            this.g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if (this.electricHockeyApplication.getControlPanel().getShowField() && this.electricHockeyApplication.getModel().getChargeListSize() != 0) {
            this.g2D.drawRenderedImage(this.fieldLinesImage, new AffineTransform());
        }
        this.g2D.drawImage(this.electricHockeyApplication.plusBag, this.plusBag.x, this.plusBag.y, this);
        this.g2D.setColor(Color.black);
        this.g2D.drawRect(this.plusBag.x, this.plusBag.y, this.plusBag.width, this.plusBag.height);
        this.g2D.drawImage(this.electricHockeyApplication.minusBag, this.minusBag.x, this.minusBag.y, this);
        this.g2D.setColor(Color.black);
        this.g2D.drawRect(this.minusBag.x, this.minusBag.y, this.minusBag.width, this.minusBag.height);
        if (this.newChargeIsGrabbed) {
            this.grabbedCharge.paint(this.g2D);
            this.grabbedChargeForce.paint(this.g2D);
        }
        this.g2D.setColor(this.barrierColor);
        this.barrierState = this.electricHockeyApplication.getControlPanel().getLevelState();
        for (n = 0; n < BarrierList.currentRectArray[this.barrierState].length; ++n) {
            int n2 = BarrierList.currentRectArray[this.barrierState][n].x;
            int n3 = BarrierList.currentRectArray[this.barrierState][n].y;
            int n4 = BarrierList.currentRectArray[this.barrierState][n].width;
            int n5 = BarrierList.currentRectArray[this.barrierState][n].height;
            this.g2D.fill3DRect(n2, n3, n4, n5, true);
        }
        for (n = 0; n < this.electricHockeyApplication.getModel().getChargeListSize(); ++n) {
            Charge charge = this.electricHockeyApplication.getModel().getChargeAt(n);
            if (charge.getSign() == -1) {
                this.g2D.drawImage(this.electricHockeyApplication.minusDisk, charge.getPosition().x - charge.radius, charge.getPosition().y - charge.radius, this);
            } else if (charge.getSign() == 1) {
                this.g2D.drawImage(this.electricHockeyApplication.plusDisk, charge.getPosition().x - charge.radius, charge.getPosition().y - charge.radius, this);
            }
            Force force = this.electricHockeyApplication.getModel().getForceAt(n);
            force.paint(this.g2D);
        }
        Charge charge = this.electricHockeyApplication.getModel().getPuck();
        if (charge.getSign() == 1) {
            this.g2D.drawImage(this.electricHockeyApplication.positivePuckImage, charge.getPosition().x - charge.radius, charge.getPosition().y - charge.radius, this);
        } else {
            this.g2D.drawImage(this.electricHockeyApplication.negativePuckImage, charge.getPosition().x - charge.radius, charge.getPosition().y - charge.radius, this);
        }
        this.g2D.setFont(this.fieldFont);
        if (this.electricHockeyApplication.getModel().getGoalState()) {
            this.g2D.setColor(new Color(0, 125, 0));
            this.g2D.setFont(new Font("serif", 0, 110));
            this.g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.g2D.drawString(SimStrings.getInstance().getString("HockeyPlayingField.Goal"), 3 * this.fieldWidth / 10, this.fieldHeight / 5);
        }
        if (this.electricHockeyApplication.getModel().getCollisionState() && !this.electricHockeyApplication.getModel().getGoalState()) {
            this.g2D.setColor(Color.red);
            this.g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.g2D.drawString(SimStrings.getInstance().getString("HockeyPlayingField.Collision"), 2 * this.fieldWidth / 5, this.fieldHeight / 10);
        }
        if (this.electricHockeyApplication.getControlPanel().getTraceState()) {
            this.g2D.setColor(Color.black);
            Stroke stroke = this.g2D.getStroke();
            this.g2D.setStroke(this.pathStroke);
            this.g2D.setColor(this.pathColor);
            this.g2D.draw(this.electricHockeyApplication.getModel().getPath());
            this.g2D.setStroke(stroke);
        }
    }

    public void prt(String string) {
        System.out.println(string);
    }

    class FieldMouseMotionListener
    extends MouseMotionAdapter {
        FieldMouseMotionListener() {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            Object object;
            if (PlayingField.this.newChargeIsGrabbed || PlayingField.this.oldChargeIsGrabbed) {
                PlayingField.this.grabbedCharge.setPosition(mouseEvent.getPoint());
                PlayingField.this.grabbedChargeForce = new Force(PlayingField.this.grabbedCharge, PlayingField.this.electricHockeyApplication.getModel().getPuck());
            }
            if (PlayingField.this.oldChargeIsGrabbed) {
                PlayingField.this.electricHockeyApplication.getModel().getChargeList().setElementAt(PlayingField.this.grabbedCharge, PlayingField.this.grabbedChargeIndex);
                object = PlayingField.this.electricHockeyApplication.getModel().getPuck();
                Force force = new Force(PlayingField.this.grabbedCharge, (Charge)object);
                PlayingField.this.electricHockeyApplication.getModel().getForceList().setElementAt(force, PlayingField.this.grabbedChargeIndex);
                PlayingField.this.electricHockeyApplication.getFieldGrid().updateGridForceArray();
            }
            object = (Graphics2D)PlayingField.this.fieldLinesImage.getGraphics();
            PlayingField.this.electricHockeyApplication.getFieldGrid().paint((Graphics2D)object);
            PlayingField.this.repaint();
        }
    }

    class FieldMouseListener
    extends MouseAdapter {
        FieldMouseListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (PlayingField.this.plusBag.contains(mouseEvent.getPoint())) {
                PlayingField.this.prt("Plus bag selected.");
                PlayingField.this.newChargeIsGrabbed = true;
                PlayingField.this.grabbedCharge = new Charge(mouseEvent.getPoint(), 1);
                PlayingField.this.grabbedChargeForce = new Force(PlayingField.this.grabbedCharge, PlayingField.this.electricHockeyApplication.getModel().getPuck());
            } else if (PlayingField.this.minusBag.contains(mouseEvent.getPoint())) {
                PlayingField.this.prt("Minus bag selected.");
                PlayingField.this.newChargeIsGrabbed = true;
                PlayingField.this.grabbedCharge = new Charge(mouseEvent.getPoint(), -1);
                PlayingField.this.grabbedChargeForce = new Force(PlayingField.this.grabbedCharge, PlayingField.this.electricHockeyApplication.getModel().getPuck());
            } else {
                for (int i = 0; i < PlayingField.this.electricHockeyApplication.getModel().getChargeListSize(); ++i) {
                    Charge charge = PlayingField.this.electricHockeyApplication.getModel().getChargeAt(i);
                    if (!charge.contains(mouseEvent.getPoint())) continue;
                    PlayingField.this.oldChargeIsGrabbed = true;
                    PlayingField.this.grabbedChargeIndex = i;
                    PlayingField.this.grabbedCharge = charge;
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (PlayingField.this.newChargeIsGrabbed) {
                PlayingField.this.newChargeIsGrabbed = false;
                if (!PlayingField.this.chargeBag.contains(mouseEvent.getPoint())) {
                    PlayingField.this.electricHockeyApplication.getModel().addCharge(PlayingField.this.grabbedCharge);
                    PlayingField.this.prt("Nbr of charges " + PlayingField.this.electricHockeyApplication.getModel().getChargeListSize());
                    PlayingField.this.electricHockeyApplication.getControlPanel().setNbrChargesLbl(PlayingField.this.electricHockeyApplication.getModel().getChargeListSize());
                }
            }
            if (PlayingField.this.oldChargeIsGrabbed) {
                PlayingField.this.oldChargeIsGrabbed = false;
                if (PlayingField.this.chargeBag.contains(mouseEvent.getPoint())) {
                    PlayingField.this.electricHockeyApplication.getModel().removeChargeAt(PlayingField.this.grabbedChargeIndex);
                    PlayingField.this.prt("edu.colorado.phet.ehockey.Charge " + PlayingField.this.grabbedChargeIndex + " removed.");
                    PlayingField.this.electricHockeyApplication.getControlPanel().setNbrChargesLbl(PlayingField.this.electricHockeyApplication.getModel().getChargeListSize());
                }
            }
            PlayingField.this.electricHockeyApplication.getFieldGrid().updateGridForceArray();
            PlayingField.this.updateBufferedImage();
            PlayingField.this.repaint();
        }
    }
}

