/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.ehockey;

import edu.colorado.phet.ehockey.BarrierList;
import edu.colorado.phet.ehockey.Charge;
import edu.colorado.phet.ehockey.ElectricHockeyApplication;
import edu.colorado.phet.ehockey.Force;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.Vector;
import javax.swing.Timer;

public class Model {
    private ElectricHockeyApplication electricHockeyApplication;
    private int fieldWidth;
    private int fieldHeight;
    private int barrierState;
    private boolean goalState;
    private boolean collisionState;
    private boolean pathStarted;
    private boolean puckMoving;
    private GeneralPath path;
    private Vector chargeList;
    private Vector forceList;
    private final Point2D initialPuckPosition2D;
    private Point puckPosition;
    private Point2D puckPosition2D;
    private Charge puck;
    private double mass = 25.0;
    private Force netForce;
    private double fFactor = 0.002;
    private Timer timer;
    private int dt = 3;
    private int time;
    private double x;
    private double y;
    private double xBefore;
    private double yBefore;
    private double xTemp;
    private double yTemp;
    private boolean starting;
    private double vX;
    private double vY;

    public Model(int n, int n2, ElectricHockeyApplication electricHockeyApplication) {
        this.electricHockeyApplication = electricHockeyApplication;
        this.fieldWidth = n;
        this.fieldHeight = n2;
        this.chargeList = new Vector();
        this.forceList = new Vector();
        this.goalState = false;
        this.collisionState = false;
        this.puckMoving = false;
        this.puckPosition = new Point(this.fieldWidth / 5, this.fieldHeight / 2);
        this.puckPosition2D = this.initialPuckPosition2D = new Point2D.Double((double)this.fieldWidth / 5.0, (double)this.fieldHeight / 2.0);
        this.pathStarted = false;
        this.path = new GeneralPath();
        this.puck = new Charge(this.puckPosition2D, 1);
        this.x = this.puckPosition2D.getX();
        this.y = this.puckPosition2D.getY();
        this.starting = true;
        this.vX = 0.0;
        this.vY = 0.0;
        this.timer = new Timer(this.dt, new timerHandler());
    }

    public void updateForceList() {
        for (int i = 0; i < this.forceList.size(); ++i) {
            Charge charge = (Charge)this.chargeList.elementAt(i);
            Force force = new Force(charge, this.puck);
            this.forceList.setElementAt(force, i);
        }
    }

    public void addCharge(Charge charge) {
        this.chargeList.addElement(charge);
        Force force = new Force(charge, this.puck);
        this.forceList.addElement(force);
    }

    public void removeChargeAt(int n) {
        this.chargeList.removeElementAt(n);
        this.forceList.removeElementAt(n);
    }

    public int getChargeListSize() {
        return this.chargeList.size();
    }

    public Charge getChargeAt(int n) {
        Charge charge = (Charge)this.chargeList.elementAt(n);
        return charge;
    }

    public Force getForceAt(int n) {
        Force force = (Force)this.forceList.elementAt(n);
        return force;
    }

    public Vector getChargeList() {
        return this.chargeList;
    }

    public Vector getForceList() {
        return this.forceList;
    }

    public Charge getPuck() {
        return this.puck;
    }

    public void setMass(double d) {
        this.mass = d;
    }

    public Force getNetForce() {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < this.forceList.size(); ++i) {
            Force force = (Force)this.forceList.elementAt(i);
            d += force.getXComp();
            d2 += force.getYComp();
        }
        this.netForce = new Force(d, d2);
        return this.netForce;
    }

    public void updatePuckPositionVerlet() {
        if (this.starting) {
            Force force = this.getNetForce();
            this.xBefore = this.x;
            this.yBefore = this.y;
            this.x += this.fFactor * force.getXComp() / (2.0 * this.mass) * (double)this.dt * (double)this.dt;
            this.y += this.fFactor * force.getYComp() / (2.0 * this.mass) * (double)this.dt * (double)this.dt;
            this.starting = false;
        } else {
            Force force = this.getNetForce();
            this.xTemp = this.x;
            this.yTemp = this.y;
            this.x = 2.0 * this.x - this.xBefore + this.fFactor * force.getXComp() / this.mass * (double)this.dt * (double)this.dt;
            this.y = 2.0 * this.y - this.yBefore + this.fFactor * force.getYComp() / this.mass * (double)this.dt * (double)this.dt;
            this.xBefore = this.xTemp;
            this.yBefore = this.yTemp;
            this.puck.setPosition2D(new Point2D.Double(this.x, this.y));
            this.puck.setPosition(new Point((int)this.x, (int)this.y));
            this.updateForceList();
            if (this.x > (double)(3 * this.fieldWidth) || this.x < (double)(-3 * this.fieldWidth) || this.y > (double)(3 * this.fieldHeight) || this.y < (double)(-3 * this.fieldHeight)) {
                this.stopTimer();
            }
        }
    }

    public void updatePath() {
        if (!this.pathStarted) {
            this.path.moveTo(this.puck.getPosition().x, this.puck.getPosition().y);
            this.pathStarted = true;
        } else {
            this.path.lineTo(this.puck.getPosition().x, this.puck.getPosition().y);
        }
    }

    public void setPathStarted(boolean bl) {
        this.pathStarted = bl;
    }

    public GeneralPath getPath() {
        return this.path;
    }

    public void setBarrierState(int n) {
        this.barrierState = n;
        switch (this.barrierState) {
            case 0: {
                BarrierList.currentCollisionArray = BarrierList.collisionArray0;
                break;
            }
            case 1: {
                BarrierList.currentCollisionArray = BarrierList.collisionArray1;
                break;
            }
            case 2: {
                BarrierList.currentCollisionArray = BarrierList.collisionArray2;
                break;
            }
            case 3: {
                BarrierList.currentCollisionArray = BarrierList.collisionArray3;
            }
        }
    }

    public void startTimer() {
        this.timer.start();
        this.puckMoving = true;
        this.prt("Timer started");
    }

    public void stopTimer() {
        this.timer.stop();
        this.puckMoving = false;
    }

    public void resetTimer() {
        this.timer.stop();
        this.puckMoving = false;
        this.time = 0;
        this.x = this.initialPuckPosition2D.getX();
        this.y = this.initialPuckPosition2D.getY();
        this.vX = 0.0;
        this.vY = 0.0;
        this.puck.setPosition2D(this.initialPuckPosition2D);
        this.puck.setPosition(new Point((int)this.initialPuckPosition2D.getX(), (int)this.initialPuckPosition2D.getY()));
        this.updateForceList();
        this.path.reset();
        this.pathStarted = false;
        this.starting = true;
        this.goalState = false;
        this.collisionState = false;
        this.prt("positivePuckImage reset y = " + this.puckPosition2D.getY());
        this.electricHockeyApplication.getPlayingField().paintAgain();
    }

    public boolean getCollisionState() {
        return this.collisionState;
    }

    public boolean getGoalState() {
        return this.goalState;
    }

    public void prt(String string) {
        System.out.println(string);
    }

    class timerHandler
    implements ActionListener {
        timerHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Model.this.time++;
            Model.this.updatePuckPositionVerlet();
            if (Model.this.electricHockeyApplication.getControlPanel().getTraceState()) {
                Model.this.updatePath();
            }
            int n = ((Model)Model.this).puck.getPosition().x;
            int n2 = ((Model)Model.this).puck.getPosition().y;
            if (n > 0 && n < Model.this.fieldWidth && n2 > 0 && n2 < Model.this.fieldHeight && BarrierList.currentCollisionArray[n][n2] == 1) {
                Model.this.prt("Collision!");
                Model.this.collisionState = true;
                if (((Model)Model.this).electricHockeyApplication.cork != null) {
                    ((Model)Model.this).electricHockeyApplication.cork.play();
                }
                Model.this.electricHockeyApplication.getPlayingField().paintAgain();
                Model.this.stopTimer();
            }
            if (((Model)Model.this).electricHockeyApplication.getPlayingField().goal.contains(Model.this.puck.getPosition())) {
                Model.this.prt("Goal!");
                Model.this.goalState = true;
                if (((Model)Model.this).electricHockeyApplication.tada != null) {
                    ((Model)Model.this).electricHockeyApplication.tada.play();
                }
                Model.this.electricHockeyApplication.getPlayingField().paintAgain();
                Model.this.stopTimer();
            }
            Model.this.electricHockeyApplication.getPlayingField().paintAgain();
        }
    }
}

