/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.ehockey;

import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.view.util.SimStrings;
import edu.colorado.phet.ehockey.BarrierList;
import edu.colorado.phet.ehockey.ControlPanel;
import edu.colorado.phet.ehockey.FieldGrid;
import edu.colorado.phet.ehockey.Model;
import edu.colorado.phet.ehockey.MyClipLoader;
import edu.colorado.phet.ehockey.PlayingField;
import edu.colorado.phet.ehockey.ResourceLoader4;
import edu.colorado.phet.ehockey.common.SwingUtils;
import java.applet.AudioClip;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.Toolkit;
import java.util.Locale;
import javax.swing.JApplet;
import javax.swing.JFrame;

public class ElectricHockeyApplication
extends JApplet
implements Runnable {
    static boolean isApplet = true;
    private int width;
    private int height;
    private PlayingField playingField;
    private Model model;
    private FieldGrid fieldGrid;
    private ControlPanel controlPanel;
    private BarrierList barrierList;
    AudioClip tada;
    AudioClip cork;
    Image plusDisk;
    Image minusDisk;
    Image plusBag;
    Image minusBag;
    Image positivePuckImage;
    Container pane;
    MyClipLoader mcl;
    public Image negativePuckImage;

    public void init() {
        Object object;
        this.width = 700;
        this.height = 600;
        if (isApplet) {
            object = Toolkit.getProperty("javaws.phet.locale", null);
            if (object != null && !((String)object).equals("")) {
                SimStrings.getInstance().setLocale(new Locale((String)object));
            }
            SimStrings.getInstance().addStrings("electric-hockey/localization/electric-hockey-strings");
        }
        this.barrierList = new BarrierList(this);
        this.model = new Model(this.width, this.height, this);
        this.fieldGrid = new FieldGrid(this.width, this.height, this);
        this.controlPanel = new ControlPanel(this);
        this.playingField = new PlayingField(this.width, this.height, this);
        object = this.getClass().getClassLoader();
        this.mcl = new MyClipLoader((ClassLoader)object, this);
        ResourceLoader4 resourceLoader4 = new ResourceLoader4((ClassLoader)object, this);
        new Thread(this).start();
        this.plusDisk = this.getImage(resourceLoader4, "plusDisk.gif");
        this.minusDisk = this.getImage(resourceLoader4, "minusDisk.gif");
        this.plusBag = this.getImage(resourceLoader4, "plusBag.gif");
        this.minusBag = this.getImage(resourceLoader4, "minusBag.gif");
        this.positivePuckImage = this.getImage(resourceLoader4, "puckPositive.gif");
        this.negativePuckImage = this.getImage(resourceLoader4, "puckNegative.gif");
        this.pane = this.getContentPane();
        this.pane.setLayout(new BorderLayout());
        this.pane.add((Component)this.playingField, "Center");
        this.pane.add((Component)this.controlPanel, "South");
    }

    public AudioClip getAudioClip(MyClipLoader myClipLoader, String string) {
        return myClipLoader.loadAudioClip(string);
    }

    public Image getImage(ResourceLoader4 resourceLoader4, String string) {
        return resourceLoader4.loadBufferedImage("electric-hockey/images/" + string);
    }

    public PlayingField getPlayingField() {
        return this.playingField;
    }

    public FieldGrid getFieldGrid() {
        return this.fieldGrid;
    }

    public Model getModel() {
        return this.model;
    }

    public ControlPanel getControlPanel() {
        return this.controlPanel;
    }

    public static void main(String[] stringArray) {
        SimStrings.getInstance().init(stringArray, "electric-hockey/localization/electric-hockey-strings");
        isApplet = false;
        JFrame jFrame = new JFrame(SimStrings.getInstance().getString("HockeyApplication.Title") + " (" + PhetApplicationConfig.getVersion("electric-hockey").formatForTitleBar() + ")");
        ElectricHockeyApplication electricHockeyApplication = new ElectricHockeyApplication();
        jFrame.setContentPane(electricHockeyApplication);
        jFrame.setSize(800, 750);
        electricHockeyApplication.init();
        jFrame.setDefaultCloseOperation(3);
        SwingUtils.centerWindowOnScreen(jFrame);
        jFrame.setVisible(true);
        jFrame.invalidate();
        jFrame.repaint();
        jFrame.validate();
        jFrame.repaint();
    }

    public void run() {
        this.tada = this.getAudioClip(this.mcl, "electric-hockey/audio/tada.WAV");
        this.cork = this.getAudioClip(this.mcl, "electric-hockey/audio/cork.au");
    }

    public boolean isAntialias() {
        return this.fieldGrid.isAntialias();
    }
}

