/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.ehockey;

import edu.colorado.phet.common.phetcommon.view.util.SimStrings;
import edu.colorado.phet.ehockey.Charge;
import edu.colorado.phet.ehockey.ElectricHockeyApplication;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ControlPanel
extends JPanel {
    private ElectricHockeyApplication electricHockeyApplication;
    private JButton startBtn;
    private JButton resetBtn;
    private JButton clearBtn;
    private JCheckBox pauseChkBox;
    private boolean toggleTrace;
    private boolean showField;
    private JCheckBox traceChkBox;
    private JCheckBox fieldGridChkBox;
    private JRadioButton radio0;
    private JRadioButton radio1;
    private JRadioButton radio2;
    private JRadioButton radio3;
    private JLabel difficultyLbl;
    private int nbrTries;
    private JLabel nbrTriesLbl;
    private JLabel nbrChargesLbl;
    private JLabel massLbl;
    private JTextField massText;
    private JSlider massSlider;
    private int levelState;
    private ButtonGroup btnGroup;
    private JPanel panelTop;
    private JPanel panelLeft;
    private JPanel panelMid;
    private JPanel panelRight;
    private JPanel panelBottom;
    private JPanel panelBottomLeft;
    private JPanel panelBottomRight;

    public ControlPanel(final ElectricHockeyApplication electricHockeyApplication) {
        this.electricHockeyApplication = electricHockeyApplication;
        this.startBtn = new JButton(SimStrings.getInstance().getString("HockeyControlPanel.Start"));
        this.resetBtn = new JButton(SimStrings.getInstance().getString("HockeyControlPanel.Reset"));
        this.nbrTries = 0;
        this.nbrTriesLbl = new JLabel(SimStrings.getInstance().getString("HockeyControlPanel.Tries") + this.nbrTries);
        this.clearBtn = new JButton(SimStrings.getInstance().getString("HockeyControlPanel.Clear"));
        this.pauseChkBox = new JCheckBox(SimStrings.getInstance().getString("HockeyControlPanel.Pause"), false);
        this.pauseChkBox.setBackground(Color.yellow);
        this.traceChkBox = new JCheckBox(SimStrings.getInstance().getString("HockeyControlPanel.Trace"), false);
        this.traceChkBox.setBackground(Color.yellow);
        this.toggleTrace = false;
        final JCheckBox jCheckBox = new JCheckBox(SimStrings.getInstance().getString("HockeyControlPanel.PuckIsPositive"), true);
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = jCheckBox.isSelected();
                Charge charge = electricHockeyApplication.getModel().getPuck();
                if (bl) {
                    charge.setSign(1);
                } else {
                    charge.setSign(-1);
                }
                electricHockeyApplication.getPlayingField().repaint();
                electricHockeyApplication.getModel().updatePath();
                electricHockeyApplication.getModel().updateForceList();
            }
        });
        jCheckBox.setBackground(Color.yellow);
        this.fieldGridChkBox = new JCheckBox(SimStrings.getInstance().getString("HockeyControlPanel.Field"), false);
        this.fieldGridChkBox.setBackground(Color.yellow);
        this.showField = false;
        final JCheckBox jCheckBox2 = new JCheckBox("Antialias", electricHockeyApplication.getFieldGrid().isAntialias());
        jCheckBox2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                electricHockeyApplication.getFieldGrid().setAntialias(jCheckBox2.isSelected());
            }
        });
        jCheckBox2.setBackground(Color.yellow);
        this.radio0 = new JRadioButton(SimStrings.getInstance().getString("HockeyControlPanel.Practice"), true);
        this.radio1 = new JRadioButton("1", false);
        this.radio2 = new JRadioButton("2", false);
        this.radio3 = new JRadioButton("3", false);
        this.difficultyLbl = new JLabel(SimStrings.getInstance().getString("HockeyControlPanel.Difficulty"));
        String string = SimStrings.getInstance().getString("HockeyControlPanel.Charges") + electricHockeyApplication.getModel().getChargeListSize();
        this.nbrChargesLbl = new JLabel(string);
        this.nbrChargesLbl.setBackground(Color.green);
        this.levelState = 0;
        this.radio0.setBackground(Color.green);
        this.radio1.setBackground(Color.green);
        this.radio2.setBackground(Color.green);
        this.radio3.setBackground(Color.green);
        this.btnGroup = new ButtonGroup();
        this.btnGroup.add(this.radio0);
        this.btnGroup.add(this.radio1);
        this.btnGroup.add(this.radio2);
        this.btnGroup.add(this.radio3);
        this.massLbl = new JLabel(SimStrings.getInstance().getString("HockeyControlPanel.Mass"));
        this.massLbl.setBackground(Color.green);
        int n = 25;
        this.massText = new JTextField(Integer.toString(n), 3);
        this.massSlider = new JSlider(1, 100, n);
        this.massSlider.setMajorTickSpacing(10);
        this.massSlider.setMinorTickSpacing(1);
        this.massSlider.setBackground(Color.green);
        this.panelTop = new JPanel();
        this.panelLeft = new JPanel();
        this.panelMid = new JPanel();
        this.panelRight = new JPanel();
        this.panelLeft.setBackground(Color.yellow);
        this.panelMid.setBackground(Color.yellow);
        this.panelRight.setBackground(Color.yellow);
        this.panelBottom = new JPanel();
        this.panelBottom.setBackground(Color.green);
        this.panelBottomLeft = new JPanel();
        this.panelBottomRight = new JPanel();
        this.panelBottomLeft.setBackground(Color.green);
        this.panelBottomRight.setBackground(Color.green);
        this.startBtn.addActionListener(new StartBtnHandler());
        this.resetBtn.addActionListener(new ResetBtnHandler());
        this.pauseChkBox.addActionListener(new PauseChkBoxHandler());
        this.clearBtn.addActionListener(new ClearBtnHandler());
        this.traceChkBox.addActionListener(new TraceChkBoxHandler());
        this.fieldGridChkBox.addActionListener(new FieldGridChkBoxHandler());
        this.massText.addActionListener(new MassTextListener());
        this.massSlider.addChangeListener(new SliderHandler());
        this.resetBtn.setEnabled(false);
        this.radio0.addItemListener(new LevelBtnHandler());
        this.radio1.addItemListener(new LevelBtnHandler());
        this.radio2.addItemListener(new LevelBtnHandler());
        this.radio3.addItemListener(new LevelBtnHandler());
        this.panelLeft.add(this.startBtn);
        this.panelLeft.add(this.resetBtn);
        this.panelLeft.add(this.nbrTriesLbl);
        this.panelMid.add(this.pauseChkBox);
        this.panelMid.add(this.clearBtn);
        this.panelTop.setBackground(Color.yellow);
        this.panelRight.setBackground(Color.yellow);
        this.panelRight.add(jCheckBox);
        this.panelRight.add(this.traceChkBox);
        this.panelRight.add(this.fieldGridChkBox);
        this.panelRight.add(jCheckBox2);
        this.panelBottomLeft.add(this.radio0);
        this.panelBottomLeft.add(this.difficultyLbl);
        this.panelBottomLeft.add(this.radio1);
        this.panelBottomLeft.add(this.radio2);
        this.panelBottomLeft.add(this.radio3);
        this.panelBottomLeft.add(this.nbrChargesLbl);
        this.panelBottomRight.add(this.massLbl);
        this.panelBottomRight.add(this.massText);
        this.panelBottomRight.add(this.massSlider);
        this.panelTop.setLayout(new FlowLayout());
        this.panelTop.add(this.panelLeft);
        this.panelTop.add(this.panelMid);
        this.panelTop.add(this.panelRight);
        this.panelBottom.setLayout(new GridLayout(1, 2));
        this.panelBottom.add(this.panelBottomLeft);
        this.panelBottom.add(this.panelBottomRight);
        this.setLayout(new GridLayout(2, 1));
        this.add(this.panelTop);
        this.add(this.panelBottom);
    }

    public boolean getTraceState() {
        return this.toggleTrace;
    }

    public boolean getShowField() {
        return this.showField;
    }

    public int getLevelState() {
        return this.levelState;
    }

    public void setNbrTriesLbl() {
        this.nbrTriesLbl.setText(SimStrings.getInstance().getString("HockeyControlPanel.Tries") + new Integer(this.nbrTries).toString());
    }

    public void setNbrChargesLbl(int n) {
        this.nbrChargesLbl.setText(SimStrings.getInstance().getString("HockeyControlPanel.Charges") + new Integer(n).toString());
    }

    public void prt(String string) {
        System.out.println(string);
    }

    private class SliderHandler
    implements ChangeListener {
        private SliderHandler() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (changeEvent.getSource() == ControlPanel.this.massSlider) {
                int n = ControlPanel.this.massSlider.getValue();
                ControlPanel.this.electricHockeyApplication.getModel().setMass(n);
                ControlPanel.this.massText.setText(new Integer(n).toString());
            }
        }
    }

    private class MassTextListener
    implements ActionListener {
        private MassTextListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == ControlPanel.this.massText) {
                try {
                    double d = Double.parseDouble(ControlPanel.this.massText.getText());
                    ControlPanel.this.electricHockeyApplication.getModel().setMass(d);
                    if (d >= 1.0 && d <= 99.0) {
                        ControlPanel.this.massSlider.setValue((int)d);
                    } else if (d < 1.0) {
                        ControlPanel.this.massSlider.setValue(1);
                    } else if (d > 100.0) {
                        ControlPanel.this.massSlider.setValue(99);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    ControlPanel.this.prt("You must enter a number.");
                }
            }
        }
    }

    private class LevelBtnHandler
    implements ItemListener {
        private LevelBtnHandler() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getSource() == ControlPanel.this.radio0) {
                ControlPanel.this.levelState = 0;
            } else if (itemEvent.getSource() == ControlPanel.this.radio1) {
                ControlPanel.this.levelState = 1;
            } else if (itemEvent.getSource() == ControlPanel.this.radio2) {
                ControlPanel.this.levelState = 2;
            } else if (itemEvent.getSource() == ControlPanel.this.radio3) {
                ControlPanel.this.levelState = 3;
            }
            ControlPanel.this.nbrTries = 0;
            ControlPanel.this.setNbrTriesLbl();
            ControlPanel.this.electricHockeyApplication.getModel().setBarrierState(ControlPanel.this.levelState);
            ControlPanel.this.electricHockeyApplication.getPlayingField().paintAgain();
        }
    }

    private class FieldGridChkBoxHandler
    implements ActionListener {
        private FieldGridChkBoxHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == ControlPanel.this.fieldGridChkBox) {
                if (ControlPanel.this.fieldGridChkBox.isSelected()) {
                    ControlPanel.this.showField = true;
                    ControlPanel.this.electricHockeyApplication.getPlayingField().paintAgain();
                } else {
                    ControlPanel.this.showField = false;
                    ControlPanel.this.electricHockeyApplication.getPlayingField().paintAgain();
                }
            }
        }
    }

    private class TraceChkBoxHandler
    implements ActionListener {
        private TraceChkBoxHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == ControlPanel.this.traceChkBox) {
                if (ControlPanel.this.traceChkBox.isSelected()) {
                    ControlPanel.this.toggleTrace = true;
                    ControlPanel.this.electricHockeyApplication.getModel().setPathStarted(false);
                    ControlPanel.this.electricHockeyApplication.getModel().getPath().reset();
                } else {
                    ControlPanel.this.toggleTrace = false;
                }
            }
        }
    }

    private class ClearBtnHandler
    implements ActionListener {
        private ClearBtnHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = ControlPanel.this.electricHockeyApplication.getModel().getChargeListSize();
            ControlPanel.this.prt("ChargeList length = " + n);
            for (int i = n - 1; i >= 0; --i) {
                ControlPanel.this.electricHockeyApplication.getModel().removeChargeAt(i);
            }
            ControlPanel.this.electricHockeyApplication.getFieldGrid().updateGridForceArray();
            ControlPanel.this.prt("Cleared chargelist length = " + ControlPanel.this.electricHockeyApplication.getModel().getChargeListSize());
            ControlPanel.this.electricHockeyApplication.getModel().stopTimer();
            ControlPanel.this.electricHockeyApplication.getPlayingField().paintAgain();
        }
    }

    private class PauseChkBoxHandler
    implements ActionListener {
        private PauseChkBoxHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (ControlPanel.this.pauseChkBox.isSelected()) {
                ControlPanel.this.electricHockeyApplication.getModel().stopTimer();
                ControlPanel.this.startBtn.setEnabled(false);
                ControlPanel.this.resetBtn.setEnabled(false);
                ControlPanel.this.clearBtn.setEnabled(false);
            } else {
                ControlPanel.this.electricHockeyApplication.getModel().startTimer();
                ControlPanel.this.startBtn.setEnabled(true);
                ControlPanel.this.resetBtn.setEnabled(true);
                ControlPanel.this.clearBtn.setEnabled(true);
            }
        }
    }

    private class ResetBtnHandler
    implements ActionListener {
        private ResetBtnHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == ControlPanel.this.resetBtn) {
                ControlPanel.this.prt("Reset button pushed");
            }
            ControlPanel.this.electricHockeyApplication.getModel().resetTimer();
            ControlPanel.this.nbrTries += 1;
            ControlPanel.this.setNbrTriesLbl();
            ControlPanel.this.resetBtn.setEnabled(false);
            ControlPanel.this.startBtn.setEnabled(true);
        }
    }

    private class StartBtnHandler
    implements ActionListener {
        private StartBtnHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == ControlPanel.this.startBtn) {
                ControlPanel.this.prt("Start button pushed");
            }
            ControlPanel.this.resetBtn.setEnabled(true);
            ControlPanel.this.startBtn.setEnabled(false);
            ControlPanel.this.electricHockeyApplication.getModel().startTimer();
        }
    }
}

