/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.ehockey;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Point2D;
import javax.swing.JComponent;

public class Charge
extends JComponent {
    Point position;
    Point2D position2D;
    private Color color;
    int sign;
    int radius;

    public Charge(Point2D point2D, int n) {
        this(point2D, n, Charge.getColor(n));
    }

    private static Color getColor(int n) {
        if (n == -1) {
            return Color.blue;
        }
        if (n == 1) {
            return Color.red;
        }
        return Color.black;
    }

    public Charge(Point2D point2D, int n, Color color) {
        this.position2D = point2D;
        this.color = color;
        this.position = new Point((int)point2D.getX(), (int)point2D.getY());
        this.sign = n;
        this.radius = 8;
    }

    public void paint(Graphics2D graphics2D) {
        graphics2D.setColor(this.color);
        int n = this.position.x;
        int n2 = this.position.y;
        graphics2D.fillOval(n - this.radius, n2 - this.radius, 2 * this.radius, 2 * this.radius);
    }

    public int getSign() {
        return this.sign;
    }

    public Point getPosition() {
        return this.position;
    }

    public Point2D getPosition2D() {
        return this.position2D;
    }

    public void setPosition(Point point) {
        this.position = point;
    }

    public void setPosition2D(Point2D point2D) {
        this.position2D = point2D;
    }

    public boolean contains(Point point) {
        return point.x < this.position.x + this.radius && point.x > this.position.x - this.radius && point.y < this.position.y + this.radius && point.y > this.position.y - this.radius;
    }

    public void setSign(int n) {
        this.sign = n;
    }
}

