/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.resources;

import java.text.MessageFormat;

public class PhetVersionInfo {
    private final String major;
    private final String minor;
    private final String dev;
    private final String revision;

    public PhetVersionInfo(String string, String string2, String string3, String string4) {
        this.major = PhetVersionInfo.cleanup(string);
        this.minor = PhetVersionInfo.cleanup(string2);
        this.dev = PhetVersionInfo.cleanup(string3);
        this.revision = PhetVersionInfo.cleanup(string4);
    }

    public String getDev() {
        return this.dev;
    }

    public int getDevAsInt() {
        return PhetVersionInfo.getAsInt(this.getDev());
    }

    public String formatForTitleBar() {
        Object[] objectArray = new Object[]{this.major, this.minor, this.dev};
        String string = this.getDevAsInt() == 0 ? "{0}.{1}" : "{0}.{1}.{2}";
        return MessageFormat.format(string, objectArray);
    }

    public String formatForAboutDialog() {
        Object[] objectArray = new Object[]{this.major, this.minor, this.dev, this.revision};
        return MessageFormat.format("{0}.{1}.{2} ({3})", objectArray);
    }

    public String toString() {
        return this.formatForAboutDialog();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        PhetVersionInfo phetVersionInfo = (PhetVersionInfo)object;
        return this.dev.equals(phetVersionInfo.dev) && this.major.equals(phetVersionInfo.major) && this.minor.equals(phetVersionInfo.minor) && this.revision.equals(phetVersionInfo.revision);
    }

    public int hashCode() {
        int n = this.major.hashCode();
        n = 31 * n + this.minor.hashCode();
        n = 31 * n + this.dev.hashCode();
        n = 31 * n + this.revision.hashCode();
        return n;
    }

    private static String cleanup(String string) {
        String string2 = string;
        if (string == null) {
            string2 = "?";
        }
        return string2;
    }

    private static int getAsInt(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            n = -1;
        }
        return n;
    }
}

